/**************************************************************************/
// dyntable.cpp - for lookups, was once dynamically generated
/***************************************************************************
 * The Dawn of Time v1.69s.beta6 (c)1997-2010 Kalahn                       *
 * >> A number of people have contributed to the Dawn codebase, with the   *
 *    majority of code written by Kalahn - www.dawnoftime.org              *
 * >> To use this source code, you must fully comply with the dawn license *
 *    in licenses.txt... In particular, you may not remove this copyright  *
 *    notice.                                                              *
 **************************************************************************/
#include "include.h"
#include "dynamics.h"
#include "magic.h"

dynlookup_type dynlookup_table[]={
    { "abjuration",             SKTYPE_REALM, &gsn_abjuration },
    { "alteration",             SKTYPE_REALM, &gsn_alteration },
    { "conjuration",            SKTYPE_REALM, &gsn_conjuration },
    { "illusion",               SKTYPE_REALM, &gsn_illusion },
    { "phantasm",               SKTYPE_REALM, &gsn_phantasm },
    { "evocation",              SKTYPE_REALM, &gsn_evocation },
    { "enchantment",            SKTYPE_REALM, &gsn_enchantment },
    { "charm",                  SKTYPE_REALM, &gsn_charm },
    { "divination",             SKTYPE_REALM, &gsn_divination },
    { "necromancy",             SKTYPE_REALM, &gsn_necromancy },
    { "earth",                  SKTYPE_REALM, &gsn_earth },
    { "air",                    SKTYPE_REALM, &gsn_air },
    { "fire",                   SKTYPE_REALM, &gsn_fire },
    { "water",                  SKTYPE_REALM, &gsn_water },
    { "weather",                SKTYPE_REALM, &gsn_weather },
    { "protection",             SKTYPE_REALM, &gsn_protection },
    { "plant",                  SKTYPE_REALM, &gsn_plant },
    { "law",                    SKTYPE_REALM, &gsn_law },
    { "sun",                    SKTYPE_REALM, &gsn_sun },
    { "animal",                 SKTYPE_REALM, &gsn_animal },
    { "combat",                 SKTYPE_REALM, &gsn_combat },
    { "creation",               SKTYPE_REALM, &gsn_creation },
    { "time",                   SKTYPE_REALM, &gsn_time },
    { "summoning",              SKTYPE_REALM, &gsn_summoning },
    { "healing",                SKTYPE_REALM, &gsn_healing },
    { "beguiling",              SKTYPE_REALM, &gsn_beguiling },
    { "ceremonial",             SKTYPE_REALM, &gsn_ceremonial },
    { "epic",                   SKTYPE_REALM, &gsn_epic },
    { "esoteric",               SKTYPE_REALM, &gsn_esoteric },
    { "ethereal",               SKTYPE_REALM, &gsn_ethereal },
    { "holistic",               SKTYPE_REALM, &gsn_holistic },
    { "requiem",                SKTYPE_REALM, &gsn_requiem },
    { "acid blast",             SKTYPE_SPELL, &gsn_acid_blast },
    { "alarm",                  SKTYPE_SPELL, &gsn_alarm },
    { "eagle essence",          SKTYPE_SPELL, &gsn_animal_essence },
    { "armour",                 SKTYPE_SPELL, &gsn_armor },
    { "augment hearing",        SKTYPE_SPELL, &gsn_augment_hearing },
    { "aura of temperance",     SKTYPE_SPELL, &gsn_aura_of_temperance },
    { "barkskin",               SKTYPE_SPELL, &gsn_barkskin },
    { "benedict",               SKTYPE_SPELL, &gsn_benedict },
    { "bless",                  SKTYPE_SPELL, &gsn_bless },
    { "blessed garments",       SKTYPE_SPELL, &gsn_blessed_garments },
	{ "blessed grounds",		SKTYPE_SPELL, &gsn_blessed_grounds },
    { "blindness",              SKTYPE_SPELL, &gsn_blindness },
    { "blink",                  SKTYPE_SPELL, &gsn_blink },
    { "burning hands",          SKTYPE_SPELL, &gsn_burning_hands },
    { "call lightning",         SKTYPE_SPELL, &gsn_call_lightning },
    { "calm",                   SKTYPE_SPELL, &gsn_calm },
    { "cancellation",           SKTYPE_SPELL, &gsn_cancellation },
    { "canticle of warding",    SKTYPE_SPELL, &gsn_canticle_of_warding },
    { "cantrip",                SKTYPE_SPELL, &gsn_cantrip },
    { "cause fear",             SKTYPE_SPELL, &gsn_cause_fear },
    { "cause headache",         SKTYPE_SPELL, &gsn_cause_headache },
    { "cause critical",         SKTYPE_SPELL, &gsn_cause_critical },
    { "cause light",            SKTYPE_SPELL, &gsn_cause_light },
    { "cause serious",          SKTYPE_SPELL, &gsn_cause_serious },
    { "chain lightning",        SKTYPE_SPELL, &gsn_chain_lightning },
    { "change sex",             SKTYPE_SPELL, &gsn_change_sex },
    { "charm person",           SKTYPE_SPELL, &gsn_charm_person },
    { "chaos lace",             SKTYPE_SPELL, &gsn_chaos_lace },
    { "chaotic poison",         SKTYPE_SPELL, &gsn_chaotic_poison },
    { "chemistry",              SKTYPE_SKILL, &gsn_chemistry},
    { "chill shield",           SKTYPE_SPELL, &gsn_chill_shield },
    { "chill touch",            SKTYPE_SPELL, &gsn_chill_touch },
    { "clarity",                SKTYPE_SPELL, &gsn_clarity },
    { "colour spray",           SKTYPE_SPELL, &gsn_colour_spray },
    { "commune with dead",      SKTYPE_SPELL, &gsn_commune_with_dead },
    { "cone cold",              SKTYPE_SPELL, &gsn_cone_cold },
    { "continual light",        SKTYPE_SPELL, &gsn_continual_light },
    { "control weather",        SKTYPE_SPELL, &gsn_control_weather },
    { "create buffet",          SKTYPE_SPELL, &gsn_create_buffet },
    { "create food",            SKTYPE_SPELL, &gsn_create_food },
    { "create rose",            SKTYPE_SPELL, &gsn_create_rose },
    { "create spring",          SKTYPE_SPELL, &gsn_create_spring },
    { "create water",           SKTYPE_SPELL, &gsn_create_water },
    { "cure blindness",         SKTYPE_SPELL, &gsn_cure_blindness },
    { "cure chaotic poison",    SKTYPE_SPELL, &gsn_cure_chaotic_poison },
    { "cure critical",          SKTYPE_SPELL, &gsn_cure_critical },
    { "cure deafness",          SKTYPE_SPELL, &gsn_cure_deafness },
    { "cure disease",           SKTYPE_SPELL, &gsn_cure_disease },
    { "cure headache",          SKTYPE_SPELL, &gsn_cure_headache },
    { "cure light",             SKTYPE_SPELL, &gsn_cure_light },
    { "cure poison",            SKTYPE_SPELL, &gsn_cure_poison },
    { "cure serious",           SKTYPE_SPELL, &gsn_cure_serious },
    { "curse",                  SKTYPE_SPELL, &gsn_curse },
    { "cutting wind",           SKTYPE_SPELL, &gsn_cutting_wind },
    { "cyclone",                SKTYPE_SPELL, &gsn_cyclone },
    { "deafness",               SKTYPE_SPELL, &gsn_deafness },
    { "decay",                  SKTYPE_SPELL, &gsn_decay },
    { "detect evil",            SKTYPE_SPELL, &gsn_detect_evil },
    { "detect good",            SKTYPE_SPELL, &gsn_detect_good },
    { "dehydration",            SKTYPE_SPELL, &gsn_dehydration },
    { "detect hidden",          SKTYPE_SPELL, &gsn_detect_hidden },
    { "detect invis",           SKTYPE_SPELL, &gsn_detect_invis },
    { "detect magic",           SKTYPE_SPELL, &gsn_detect_magic },
    { "detect poison",          SKTYPE_SPELL, &gsn_detect_poison },
    { "detect scry",            SKTYPE_SPELL, &gsn_detect_scry },
    { "detect treeform",        SKTYPE_SPELL, &gsn_detect_treeform },
    { "disorientation",         SKTYPE_SPELL, &gsn_disorientation },
    { "dispel evil",            SKTYPE_SPELL, &gsn_dispel_evil },
    { "dispel good",            SKTYPE_SPELL, &gsn_dispel_good },
    { "dispel magic",           SKTYPE_SPELL, &gsn_dispel_magic },
    { "divine light",           SKTYPE_SPELL, &gsn_divine_light },
    { "downdraft",              SKTYPE_SPELL, &gsn_downdraft },
    { "dragon strength",        SKTYPE_SPELL, &gsn_dragon_strength },
    { "druidstaff",             SKTYPE_SPELL, &gsn_druidstaff },
    { "drunkenness",            SKTYPE_SPELL, &gsn_drunkeness },
    { "drain weapon",           SKTYPE_SPELL, &gsn_drain_blade },
    { "earthquake",             SKTYPE_SPELL, &gsn_earthquake },
    { "earthwalk",              SKTYPE_SPELL, &gsn_earthwalk },
    { "empower weapon",         SKTYPE_SPELL, &gsn_empower_blade },
    { "enchant armour",         SKTYPE_SPELL, &gsn_enchant_armor },
    { "enchant weapon",         SKTYPE_SPELL, &gsn_enchant_weapon },
    { "energy drain",           SKTYPE_SPELL, &gsn_energy_drain },
    { "extension",              SKTYPE_SPELL, &gsn_extension },
    { "faerie fire",            SKTYPE_SPELL, &gsn_faerie_fire },
    { "faerie fog",             SKTYPE_SPELL, &gsn_faerie_fog },
    { "farsight",               SKTYPE_SPELL, &gsn_farsight },
    { "fear magic",             SKTYPE_SPELL, &gsn_fear_magic },
    { "fiery armour",           SKTYPE_SPELL, &gsn_fiery_armour },
    { "fireball",               SKTYPE_SPELL, &gsn_fireball },
    { "fireproof",              SKTYPE_SPELL, &gsn_fireproof },
    { "fire shield",            SKTYPE_SPELL, &gsn_fire_shield },
    { "frostball",              SKTYPE_SPELL, &gsn_frostball },
    { "flame weapon",           SKTYPE_SPELL, &gsn_flame_blade },
    { "flamestrike",            SKTYPE_SPELL, &gsn_flamestrike },
    { "fling",                  SKTYPE_SPELL, &gsn_fling },
    { "fly",                    SKTYPE_SPELL, &gsn_fly },
    { "floating disc",          SKTYPE_SPELL, &gsn_floating_disc },
    { "frenzy",                 SKTYPE_SPELL, &gsn_frenzy },
    { "frost weapon",           SKTYPE_SPELL, &gsn_frost_blade },
    { "gate",                   SKTYPE_SPELL, &gsn_gate },
    { "giant strength",         SKTYPE_SPELL, &gsn_giant_strength },
    { "harm",                   SKTYPE_SPELL, &gsn_harm },
    { "haste",                  SKTYPE_SPELL, &gsn_haste },
    { "heal",                   SKTYPE_SPELL, &gsn_heal },
    { "heat metal",             SKTYPE_SPELL, &gsn_heat_metal },
    { "herbalism",              SKTYPE_SKILL, &gsn_herbalism},
    { "high area attack",       SKTYPE_SPELL, &gsn_high_area_attack },
    { "higher learning",        SKTYPE_SPELL, &gsn_higher_learning },
    { "holy aura",              SKTYPE_SPELL, &gsn_holy_aura },
    { "holy beam",              SKTYPE_SPELL, &gsn_holy_beam },
    { "holy word",              SKTYPE_SPELL, &gsn_holy_word },
    { "ice storm",              SKTYPE_SPELL, &gsn_ice_storm },
    { "icy armour",             SKTYPE_SPELL, &gsn_icy_armour },
    { "identify",               SKTYPE_SPELL, &gsn_identify },
    { "illusions grandeur",     SKTYPE_SPELL, &gsn_illusions_grandeur },
    { "immolation",             SKTYPE_SPELL, &gsn_immolation },
    { "improved phantasm",      SKTYPE_SPELL, &gsn_improved_phantasm },
    { "induce sleep",           SKTYPE_SPELL, &gsn_induce_sleep },
    { "infravision",            SKTYPE_SPELL, &gsn_infravision },
    { "invisibility",           SKTYPE_SPELL, &gsn_invisibility },
    { "iron skin",              SKTYPE_SPELL, &gsn_iron_skin },
    { "know alignment",         SKTYPE_SPELL, &gsn_know_alignment },
    { "low area attack",        SKTYPE_SPELL, &gsn_low_area_attack },
    { "lightning bolt",         SKTYPE_SPELL, &gsn_lightning_bolt },
    { "locate object",          SKTYPE_SPELL, &gsn_locate_object },
    { "logic",                  SKTYPE_SPELL, &gsn_logic },
    { "lucidity",               SKTYPE_SPELL, &gsn_lucidity },
    { "magic resistance",       SKTYPE_SPELL, &gsn_magic_resistance },
    { "magic missile",          SKTYPE_SPELL, &gsn_magic_missile },
    { "magical vestment",       SKTYPE_SPELL, &gsn_magical_vestment },
    { "maledict",               SKTYPE_SPELL, &gsn_maledict },
	{ "mana regeneration",		SKTYPE_SPELL, &gsn_mana_regeneration },
    { "mass healing",           SKTYPE_SPELL, &gsn_mass_healing },
    { "mass invis",             SKTYPE_SPELL, &gsn_mass_invis },
    { "mid area attack",        SKTYPE_SPELL, &gsn_mid_area_attack },
    { "mirage",                 SKTYPE_SPELL, &gsn_mirage },
    { "mithril glaze",          SKTYPE_SPELL, &gsn_mithril_glaze },
    { "mindspeak",              SKTYPE_SPELL, &gsn_mindspeak },
    { "mnemonics",              SKTYPE_SPELL, &gsn_mnemonics },
    { "mute",                   SKTYPE_SPELL, &gsn_mute },
    { "naturespeak",            SKTYPE_SPELL, &gsn_naturespeak },
    { "nexus",                  SKTYPE_SPELL, &gsn_nexus },
    { "night eyes",             SKTYPE_SPELL, &gsn_night_eyes },
    { "night of the leonids",   SKTYPE_SPELL, &gsn_night_of_the_leonids },
    { "oak shield",             SKTYPE_SPELL, &gsn_oak_shield },
    { "ogre strength",          SKTYPE_SPELL, &gsn_ogre_strength },
    { "otterlungs",             SKTYPE_SPELL, &gsn_otterlungs },
    { "pass door",              SKTYPE_SPELL, &gsn_pass_door },
    { "pass without trace",     SKTYPE_SPELL, &gsn_pass_without_trace },
    { "persuasion",             SKTYPE_SPELL, &gsn_persuasion },
    { "phantasmal force",       SKTYPE_SPELL, &gsn_phantasmal_force },
    { "permanance",             SKTYPE_SPELL, &gsn_permanance },
    { "pine needles",           SKTYPE_SPELL, &gsn_pine_needles },
    { "plague",                 SKTYPE_SPELL, &gsn_plague },
    { "poison",                 SKTYPE_SPELL, &gsn_poison },
    { "poison immunity",        SKTYPE_SPELL, &gsn_poison_immunity },
    { "poison rain",            SKTYPE_SPELL, &gsn_poison_rain },
    { "possession",             SKTYPE_SPELL, &gsn_possession},
    { "portal",                 SKTYPE_SPELL, &gsn_portal },
    { "assistance",             SKTYPE_SPELL, &gsn_prayer },
    { "prismatic spray",        SKTYPE_SPELL, &gsn_prismatic_spray },
    { "protection acid",        SKTYPE_SPELL, &gsn_protection_acid },
    { "protection cold",        SKTYPE_SPELL, &gsn_protection_cold },
    { "protection evil",        SKTYPE_SPELL, &gsn_protection_evil },
    { "protection fire",        SKTYPE_SPELL, &gsn_protection_fire },
    { "protection good",        SKTYPE_SPELL, &gsn_protection_good },
    { "protection lightning",   SKTYPE_SPELL, &gsn_protection_lightning },
    { "rage",                   SKTYPE_SPELL, &gsn_rage },
    { "recharge",               SKTYPE_SPELL, &gsn_recharge },
    { "refresh",                SKTYPE_SPELL, &gsn_refresh },
    { "regeneration",           SKTYPE_SPELL, &gsn_regeneration },
    { "rejuvenate",             SKTYPE_SPELL, &gsn_rejuvinate },
    { "remove curse",           SKTYPE_SPELL, &gsn_remove_curse },
    { "resist poison",          SKTYPE_SPELL, &gsn_resist_poison },
    { "resist weapons",         SKTYPE_SPELL, &gsn_resist_weapons },
    { "rocky skin",             SKTYPE_SPELL, &gsn_rocky_skin },
    { "rune edge",              SKTYPE_SPELL, &gsn_rune_edge },
    { "runic blade",            SKTYPE_SPELL, &gsn_runic_blade },
    { "sanctuary",              SKTYPE_SPELL, &gsn_sanctuary },
    { "shadowflight",           SKTYPE_SPELL, &gsn_shadowflight },
    { "shaping the chaos",      SKTYPE_SPELL, &gsn_shaping_the_chaos },
    { "shelter",                SKTYPE_SPELL, &gsn_shelter },
    { "shield",                 SKTYPE_SPELL, &gsn_shield },
    { "shocking grasp",         SKTYPE_SPELL, &gsn_shocking_grasp },
    { "shrink",                 SKTYPE_SPELL, &gsn_shrink },
    { "sleep",                  SKTYPE_SPELL, &gsn_sleep },
    { "slow",                   SKTYPE_SPELL, &gsn_slow },
    { "smite",                  SKTYPE_SPELL, &gsn_smite },
    { "spirit hammer",          SKTYPE_SPELL, &gsn_spirit_hammer },
    { "spirit walk",            SKTYPE_SPELL, &gsn_spirit_walk },
    { "stone skin",             SKTYPE_SPELL, &gsn_stone_skin },
    { "starvation",             SKTYPE_SPELL, &gsn_starvation },
    { "sober",                  SKTYPE_SPELL, &gsn_sober },
    { "strength of the land",   SKTYPE_SPELL, &gsn_strength_of_the_land },
    { "summon",                 SKTYPE_SPELL, &gsn_summon },
    { "sunfire",                SKTYPE_SPELL, &gsn_sunfire },
    { "teleport",               SKTYPE_SPELL, &gsn_teleport },
    { "thorny feet",            SKTYPE_SPELL, &gsn_thorny_feet },
    { "totemstaff",             SKTYPE_SPELL, &gsn_totemstaff },
    { "tough skin",             SKTYPE_SPELL, &gsn_tough_skin },
    { "treeform",               SKTYPE_SPELL, &gsn_treeform },
    { "true sight",             SKTYPE_SPELL, &gsn_true_sight },
    { "citytrack",              SKTYPE_SKILL, &gsn_citytrack},
    { "fieldtrack",             SKTYPE_SKILL, &gsn_fieldtrack},
    { "unholy aura",            SKTYPE_SPELL, &gsn_unholy_aura },
    { "utterdark",              SKTYPE_SPELL, &gsn_utterdark },
    { "vampiric touch",         SKTYPE_SPELL, &gsn_vampiric_touch },
    { "ventriloquate",          SKTYPE_SPELL, &gsn_ventriloquate },
    { "wall of fire",           SKTYPE_SPELL, &gsn_wall_of_fire },
    { "wall of ice",            SKTYPE_SPELL, &gsn_wall_of_ice },
    { "weaken",                 SKTYPE_SPELL, &gsn_weaken },
    { "wildstrike",             SKTYPE_SPELL, &gsn_wildstrike },
    { "wizard eye",             SKTYPE_SPELL, &gsn_wizard_eye },
    { "wind shield",            SKTYPE_SPELL, &gsn_wind_shield },
    { "word of recall",         SKTYPE_SPELL, &gsn_word_of_recall },
    { "wrath",                  SKTYPE_SPELL, &gsn_wrath },
    { "vicegrip",               SKTYPE_SPELL, &gsn_vicegrip  },
    { "summon guardian",        SKTYPE_SPELL, &gsn_summon_guardian },
    { "element ring",           SKTYPE_SPELL, &gsn_element_ring },
    { "summon vyr",             SKTYPE_SPELL, &gsn_summon_vyr },
    { "summon justice",         SKTYPE_SPELL, &gsn_summon_justice },
    { "acid breath",            SKTYPE_SPELL, &gsn_acid_breath },
    { "fire breath",            SKTYPE_SPELL, &gsn_fire_breath },
    { "frost breath",           SKTYPE_SPELL, &gsn_frost_breath },
    { "gas breath",             SKTYPE_SPELL, &gsn_gas_breath },
    { "shadow breath",          SKTYPE_SPELL, &gsn_shadow_breath },
    { "steel breath",           SKTYPE_SPELL, &gsn_steel_breath },
    { "lightning breath",       SKTYPE_SPELL, &gsn_lightning_breath }, 
    { "general purpose",        SKTYPE_UNDEFINED, &gsn_general_purpose },
    { "high explosive",         SKTYPE_UNDEFINED, &gsn_high_explosive },
    { "claw",                   SKTYPE_SKILL, &gsn_claw },
    { "gore",                   SKTYPE_SKILL, &gsn_gore },
    { "gouge",                  SKTYPE_SKILL, &gsn_gouge },
    { "cutoff",                 SKTYPE_SKILL, &gsn_cutoff },
    { "dervish",                SKTYPE_SKILL, &gsn_dervish },
    { "hurl",                   SKTYPE_SKILL, &gsn_hurl },
    { "shieldcleave",           SKTYPE_SKILL, &gsn_shieldcleave },
    { "hobble",                 SKTYPE_SKILL, &gsn_hobble },
    { "boneshatter",            SKTYPE_SKILL, &gsn_boneshatter },
    { "overhead",               SKTYPE_SKILL, &gsn_overhead },
    { "charge",                 SKTYPE_SKILL, &gsn_charge },
    { "sorcery",                SKTYPE_SKILL, &gsn_sorcery },
    { "mana focusing",          SKTYPE_SKILL, &gsn_mana_focusing },
	{ "mining",					SKTYPE_SKILL, &gsn_mining },
    { "axe",                    SKTYPE_SKILL, &gsn_axe },
    { "dagger",                 SKTYPE_SKILL, &gsn_dagger },
    { "flail",                  SKTYPE_SKILL, &gsn_flail },
    { "mace",                   SKTYPE_SKILL, &gsn_mace },
    { "polearm",                SKTYPE_SKILL, &gsn_polearm },
    { "sickle",                 SKTYPE_SKILL, &gsn_sickle },
    { "shield block",           SKTYPE_SKILL, &gsn_shield_block },
    { "dual wield",             SKTYPE_SKILL, &gsn_second },
    { "staff",                  SKTYPE_SKILL, &gsn_staff },
    { "sword",                  SKTYPE_SKILL, &gsn_sword },
    { "spear",                  SKTYPE_SKILL, &gsn_spear },
    { "whip",                   SKTYPE_SKILL, &gsn_whip },
    { "apply",                  SKTYPE_SKILL, &gsn_apply },
    { "backstab",               SKTYPE_SKILL, &gsn_backstab },
    { "bash",                   SKTYPE_SKILL, &gsn_bash },
    { "berserk",                SKTYPE_SKILL, &gsn_berserk },
    { "circle",                 SKTYPE_SKILL, &gsn_circle },
    { "dirt kicking",           SKTYPE_SKILL, &gsn_dirt_kicking },
    { "disarm",                 SKTYPE_SKILL, &gsn_disarm },
	{ "advanced dodge",			SKTYPE_SKILL, &gsn_advanced_dodge },
    { "dodge",                  SKTYPE_SKILL, &gsn_dodge },
    { "entangle",               SKTYPE_SKILL, &gsn_entangle },
    { "enhanced damage",        SKTYPE_SKILL, &gsn_enhanced_damage },
    { "herblore",               SKTYPE_SKILL, &gsn_herblore },
    { "ultra damage",           SKTYPE_SKILL, &gsn_ultra_damage },
    { "envenom",                SKTYPE_SKILL, &gsn_envenom },
    { "hand to hand",           SKTYPE_SKILL, &gsn_hand_to_hand },
    { "kick",                   SKTYPE_SKILL, &gsn_kick },
    { "parry",                  SKTYPE_SKILL, &gsn_parry },
    { "pounce",                 SKTYPE_SKILL, &gsn_pounce },
    { "rescue",                 SKTYPE_SKILL, &gsn_rescue },
    { "stifle",                 SKTYPE_SKILL, &gsn_stifle },
    { "trip",                   SKTYPE_SKILL, &gsn_trip },
    { "second attack",          SKTYPE_SKILL, &gsn_second_attack },
    { "third attack",           SKTYPE_SKILL, &gsn_third_attack },
    { "quad attack",            SKTYPE_SKILL, &gsn_quad_attack },
    { "riding",                 SKTYPE_SKILL, &gsn_riding },
    { "retreat",                SKTYPE_SKILL, &gsn_retreat },
    { "shadow",                 SKTYPE_SKILL, &gsn_shadow },
    { "cannibalize",            SKTYPE_SKILL, &gsn_cannibalize },
    { "animal training",        SKTYPE_SKILL, &gsn_animal_training },
    { "domesticate",            SKTYPE_SKILL, &gsn_domesticate },
    { "brew",                   SKTYPE_SKILL, &gsn_brew },
    { "diagnose",               SKTYPE_SKILL, &gsn_diagnose },
    { "scribe",                 SKTYPE_SKILL, &gsn_scribe },
    { "slice",                  SKTYPE_SKILL, &gsn_slice },
    { "forage",                 SKTYPE_SKILL, &gsn_forage },
    { "build",                  SKTYPE_SKILL, &gsn_build },
    { "cook",                   SKTYPE_SKILL, &gsn_cook },
    { "awareness",              SKTYPE_SKILL, &gsn_awareness },
    { "channel",                SKTYPE_SKILL, &gsn_channel },
    { "fast healing",           SKTYPE_SKILL, &gsn_fast_healing },
    { "fork",                   SKTYPE_SKILL, &gsn_fork },
    { "haggle",                 SKTYPE_SKILL, &gsn_haggle },
    { "hide",                   SKTYPE_SKILL, &gsn_hide },
    { "lay on hands",           SKTYPE_SKILL, &gsn_lay_on_hands },
    { "lore",                   SKTYPE_SKILL, &gsn_lore },
    { "meditation",             SKTYPE_SKILL, &gsn_meditation },
    { "peek",                   SKTYPE_SKILL, &gsn_peek },
    { "pick lock",              SKTYPE_SKILL, &gsn_pick_lock },
    { "place",                  SKTYPE_SKILL, &gsn_place },
    { "scan",                   SKTYPE_SKILL, &gsn_scan },
    { "sharpen",                SKTYPE_SKILL, &gsn_sharpen },
    { "sneak",                  SKTYPE_SKILL, &gsn_sneak },
    { "steal",                  SKTYPE_SKILL, &gsn_steal },
    { "scrolls",                SKTYPE_SKILL, &gsn_scrolls },
    { "staves",                 SKTYPE_SKILL, &gsn_staves },
    { "wands",                  SKTYPE_SKILL, &gsn_wands },
    { "vault",                  SKTYPE_SKILL, &gsn_vault },
    { "vanish",                 SKTYPE_SKILL, &gsn_vanish },
    { "recall",                 SKTYPE_SKILL, &gsn_recall },

	{ "blade mastery",			SKTYPE_SKILL, &gsn_blade_mastery },
	{ "arms mastery",			SKTYPE_SKILL, &gsn_arms_mastery },
	{ "magic mastery",			SKTYPE_SKILL, &gsn_magic_mastery },
	{ "dagger mastery",			SKTYPE_SKILL, &gsn_dagger_mastery },

    // Languages
    { "native",                 SKTYPE_SKILL, &gsn_native },
    { "human",                  SKTYPE_SKILL, &gsn_human },
    { "elven",                  SKTYPE_SKILL, &gsn_elven },
    { "dwarven",                SKTYPE_SKILL, &gsn_dwarven },
    { "draconian",              SKTYPE_SKILL, &gsn_draconian },
    { "gnomish",                SKTYPE_SKILL, &gsn_gnomish },
    { "halfling",               SKTYPE_SKILL, &gsn_halfling },
    { "orcish",                 SKTYPE_SKILL, &gsn_orcish },
    { "drow",                   SKTYPE_SKILL, &gsn_drow },
    { "avian",                  SKTYPE_SKILL, &gsn_avian },
    { "gnoll",                  SKTYPE_SKILL, &gsn_gnoll },
    { "lizardman",              SKTYPE_SKILL, &gsn_lizardman },
    { "alaghi",                 SKTYPE_SKILL, &gsn_alaghi },
    { "goblin",                 SKTYPE_SKILL, &gsn_goblin },
    { "haxor",                  SKTYPE_SKILL, &gsn_haxor },
    { "kobold",                 SKTYPE_SKILL, &gsn_kobold },
    { "arcaic",                 SKTYPE_SKILL, &gsn_arcaic },
    { "reverse",                SKTYPE_SKILL, &gsn_reverse },
    { "search",                 SKTYPE_SKILL, &gsn_search },
    { "trollish",               SKTYPE_SKILL, &gsn_trollish },
    { "faerie",                 SKTYPE_SKILL, &gsn_faerie },
    { "mremish",                SKTYPE_SKILL, &gsn_mremish },
	{ "halfelven",              SKTYPE_SKILL, &gsn_halfelven },
	{ "common",					SKTYPE_SKILL, &gsn_common },
    { NULL, SKTYPE_UNDEFINED, NULL}
};

dynspell_type spellpairs_table[]={
    { 0,    "spell_null", spell_null, TAR_IGNORE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_acid_blast", spell_acid_blast, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_alarm", spell_alarm, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_animal_essence", spell_animal_essence, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_armor", spell_armor, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_augment_hearing", spell_augment_hearing, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_aura_of_temperance", spell_aura_of_temperance, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_barkskin", spell_barkskin, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_benedict", spell_benedict, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_bless", spell_bless, TAR_OBJ_CHAR_DEF},
    { SPFUNC_NODAMTYPE, "spell_blessed_garments", spell_blessed_garments, TAR_CHAR_DEFENSIVE },
	{ SPFUNC_NODAMTYPE,	"spell_blessed_grounds", spell_blessed_grounds, TAR_IGNORE },
    { SPFUNC_DAMTYPE,   "spell_blindness", spell_blindness, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE,   "spell_sb_blindness", spell_sb_blindness, TAR_CHAR_OFFENSIVE}, //Meerclar
    { SPFUNC_NODAMTYPE, "spell_blink", spell_blink, TAR_DIRECTION},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_burning_hands", spell_burning_hands, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_call_lightning", spell_call_lightning, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_calm", spell_calm, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_sb_calm", spell_sb_calm, TAR_IGNORE}, //Meerclar
    { SPFUNC_NODAMTYPE, "spell_cancellation", spell_cancellation, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_canticle_of_warding", spell_canticle_of_warding, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_cantrip", spell_cantrip, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_cause_fear", spell_cause_fear, TAR_MOB_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_cause_headache", spell_cause_headache, TAR_MOB_OFFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_cause_critical", spell_cause_critical, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_cause_light", spell_cause_light, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_cause_serious", spell_cause_serious, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_chain_lightning", spell_chain_lightning, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_change_sex", spell_change_sex, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_charm_person", spell_charm_person, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_chaos_lace", spell_chaos_lace, TAR_OBJ_INV},
    { SPFUNC_DAMTYPE, "spell_chaotic_poison", spell_chaotic_poison, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_chill_shield", spell_chill_shield, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_chill_touch", spell_chill_touch, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_colour_spray", spell_colour_spray, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_commune_with_dead", spell_commune_with_dead, TAR_OBJ_INV},
    { SPFUNC_DAMTYPE, "spell_cone_cold", spell_cone_cold, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_continual_light", spell_continual_light, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_control_weather", spell_control_weather, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_create_bouquet", spell_create_bouquet, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_create_buffet", spell_create_buffet, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_create_food", spell_create_food, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_create_rose", spell_create_rose, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_create_spring", spell_create_spring, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_create_water", spell_create_water, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_cure_blindness", spell_cure_blindness, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_cure_chaotic_poison", spell_cure_chaotic_poison, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_cure_critical", spell_cure_critical, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_sb_cure_critical", spell_sb_cure_critical, TAR_CHAR_DEFENSIVE}, //Meerclar
    { SPFUNC_NODAMTYPE, "spell_cure_deafness", spell_cure_deafness, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_cure_disease", spell_cure_disease, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_cure_headache", spell_cure_headache, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_cure_light", spell_cure_light, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_sb_cure_light", spell_sb_cure_light, TAR_CHAR_DEFENSIVE}, //Meerclar
    { SPFUNC_NODAMTYPE, "spell_cure_poison", spell_cure_poison, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_cure_serious", spell_cure_serious, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_sb_cure_serious", spell_sb_cure_serious, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_curse", spell_curse, TAR_OBJ_MOB_OFF},
    { SPFUNC_DAMTYPE, "spell_cutting_wind", spell_cutting_wind, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_cyclone", spell_cyclone, TAR_CHAR_DEFENSIVE },
    { SPFUNC_DAMTYPE,   "spell_deafness", spell_deafness, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_decay", spell_decay, TAR_OBJ_CHAR_OFF},
    { SPFUNC_NODAMTYPE, "spell_detect_evil", spell_detect_evil, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_detect_good", spell_detect_good, TAR_CHAR_SELF},
    { SPFUNC_DAMTYPE, "spell_dehydration", spell_dehydration, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_detect_hidden", spell_detect_hidden, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_detect_invis", spell_detect_invis, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_detect_magic", spell_detect_magic, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_detect_poison", spell_detect_poison, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_detect_scry", spell_detect_scry, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_detect_treeform", spell_detect_treeform, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_disorientation", spell_disorientation, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_dispel_evil", spell_dispel_evil, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_dispel_good", spell_dispel_good, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_dispel_magic", spell_dispel_magic, TAR_MOB_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_divine_light", spell_divine_light, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_downdraft", spell_downdraft, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_dragon_strength", spell_dragon_strength, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_druidstaff", spell_druidstaff, TAR_IGNORE },
    { SPFUNC_DAMTYPE, "spell_drunkeness", spell_drunkeness, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_drain_blade", spell_drain_blade, TAR_OBJ_INV},
    { SPFUNC_DAMTYPE, "spell_earthquake", spell_earthquake, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_earthwalk", spell_earthwalk, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_empower_blade", spell_empower_blade, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_enchant_armor", spell_enchant_armor, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_enchant_item",   spell_enchant_item, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_enchant_weapon", spell_enchant_weapon, TAR_OBJ_INV}, 
    { SPFUNC_NODAMTYPE, "spell_energy_drain", spell_energy_drain, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_extension", spell_extension, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_faerie_fire", spell_faerie_fire, TAR_MOB_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_faerie_fog", spell_faerie_fog, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_farsight", spell_farsight, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_fear_magic", spell_fear_magic, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_fiery_armour", spell_fiery_armour, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_fireball", spell_fireball, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_fireproof", spell_fireproof, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_fire_shield", spell_fire_shield, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_frostball", spell_frostball, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_flame_blade", spell_flame_blade, TAR_OBJ_INV},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_flamestrike", spell_flamestrike, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_fling", spell_fling, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_fly", spell_fly, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_floating_disc", spell_floating_disc, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_frenzy", spell_frenzy, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_frost_blade", spell_frost_blade, TAR_OBJ_INV},
    { SPFUNC_DAMTYPE, "spell_gate", spell_gate, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_sb_gate", spell_sb_gate, TAR_IGNORE}, // -Balo-
    { SPFUNC_NODAMTYPE, "spell_giant_strength", spell_giant_strength, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_harm", spell_harm, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_haste", spell_haste, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_heal", spell_heal, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_heat_metal", spell_heat_metal, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_high_area_attack", spell_high_area_attack, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_higher_learning", spell_higher_learning, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_holy_aura", spell_holy_aura, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_holy_beam", spell_holy_beam, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_holy_word", spell_holy_word, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_sb_holy_word", spell_sb_holy_word, TAR_IGNORE}, //Meerclar
    { SPFUNC_DAMTYPE, "spell_ice_storm", spell_ice_storm, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_icy_armour", spell_icy_armour, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_identify", spell_identify, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_illusions_grandeur", spell_illusions_grandeur, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_sb_illusions_grandeur", spell_sb_illusions_grandeur, TAR_CHAR_SELF},
    { SPFUNC_DAMTYPE, "spell_immolation", spell_immolation, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_improved_phantasm", spell_improved_phantasm, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_induce_sleep", spell_induce_sleep, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_infravision", spell_infravision, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_invisibility", spell_invisibility, TAR_OBJ_CHAR_DEF},
    { SPFUNC_NODAMTYPE, "spell_iron_skin", spell_iron_skin, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_know_alignment", spell_know_alignment, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_lightning_bolt", spell_lightning_bolt, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_locate_object", spell_locate_object, TAR_IGNORE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_low_area_attack", spell_low_area_attack, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_magic_resistance", spell_magic_resistance, TAR_CHAR_SELF},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_magic_missile", spell_magic_missile, TAR_CHAR_OFFENSIVE},
  { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_sb_magic_missile", spell_sb_magic_missile, TAR_CHAR_OFFENSIVE}, //Meerclar
    { SPFUNC_NODAMTYPE, "spell_magical_vestment", spell_magical_vestment, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_maledict", spell_maledict, TAR_MOB_OFFENSIVE},
	{ SPFUNC_NODAMTYPE, "spell_mana_regeneration", spell_mana_regeneration, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_mass_healing", spell_mass_healing, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_mass_invis", spell_mass_invis, TAR_IGNORE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_mid_area_attack", spell_mid_area_attack, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_mirage", spell_mirage, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_mithril_glaze", spell_mithril_glaze, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_mindspeak", spell_mindspeak, TAR_IGNORE},
    { SPFUNC_DAMTYPE,   "spell_mute", spell_mute, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_naturespeak", spell_naturespeak, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_nexus", spell_nexus, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_night_of_the_leonids", spell_night_of_the_leonids, TAR_IGNORE },
    { SPFUNC_NODAMTYPE, "spell_oak_shield", spell_oak_shield, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_ogre_strength", spell_ogre_strength, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_otterlungs", spell_otterlungs, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_pass_door", spell_pass_door, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_pass_without_trace", spell_pass_without_trace, TAR_CHAR_SELF},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_phantasmal_force", spell_phantasmal_force, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_permanance", spell_permanance, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_pine_needles", spell_pine_needles, TAR_CHAR_SELF},
    { SPFUNC_DAMTYPE, "spell_plague", spell_plague, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_poison", spell_poison, TAR_OBJ_MOB_OFF},
    { SPFUNC_NODAMTYPE, "spell_poison_immunity", spell_poison_immunity, TAR_CHAR_SELF},
    { SPFUNC_DAMTYPE, "spell_poison_rain", spell_poison_rain, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_sb_poison_rain", spell_sb_poison_rain, TAR_IGNORE}, //Meerclar
    { SPFUNC_DAMTYPE, "spell_portal", spell_portal, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_sb_portal", spell_sb_portal, TAR_IGNORE}, // -Balo-
    { SPFUNC_NODAMTYPE, "spell_possession", spell_possession, TAR_CHAR_SELF},   
    { SPFUNC_NODAMTYPE, "spell_prayer", spell_prayer, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_prismatic_spray", spell_prismatic_spray, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_protection_acid", spell_protection_acid, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_protection_cold", spell_protection_cold, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_protection_evil", spell_protection_evil, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_sb_protection_evil", spell_sb_protection_evil, TAR_CHAR_SELF},//Meerclar
    { SPFUNC_NODAMTYPE, "spell_protection_fire", spell_protection_fire, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_protection_good", spell_protection_good, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_sb_protection_good", spell_sb_protection_good, TAR_CHAR_SELF},//Meerclar
    { SPFUNC_NODAMTYPE, "spell_protection_lightning", spell_protection_lightning, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_rage", spell_rage, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_recharge", spell_recharge, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_refresh", spell_refresh, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_regeneration", spell_regeneration, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_rejuvinate", spell_rejuvinate, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_remove_alignment", spell_remove_alignment, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_remove_curse", spell_remove_curse, TAR_OBJ_CHAR_DEF},
    { SPFUNC_NODAMTYPE, "spell_resist_poison", spell_resist_poison, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_resist_weapons", spell_resist_weapons, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_restore_mana", spell_restore_mana, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_rocky_skin", spell_rocky_skin, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_rune_edge", spell_rune_edge, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_runic_blade", spell_runic_blade, TAR_OBJ_INV},
    { SPFUNC_NODAMTYPE, "spell_sanctuary", spell_sanctuary, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_shadowflight", spell_shadowflight, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_shaping_the_chaos", spell_shaping_the_chaos, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_shelter", spell_shelter, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_shield", spell_shield, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_shrink", spell_shrink, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_shocking_grasp", spell_shocking_grasp, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_sleep", spell_sleep, TAR_MOB_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_slow", spell_slow, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_smite", spell_smite, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_spirit_hammer", spell_spirit_hammer, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_spirit_walk", spell_spirit_walk, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_stone_skin", spell_stone_skin, TAR_CHAR_SELF},
    { SPFUNC_DAMTYPE, "spell_starvation", spell_starvation, TAR_MOB_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_sober", spell_sober, TAR_CHAR_DEFENSIVE},
    { SPFUNC_DAMTYPE, "spell_strength_of_the_land", spell_strength_of_the_land, TAR_CHAR_SELF},
    { SPFUNC_DAMTYPE, "spell_sb_strength_of_the_land", spell_sb_strength_of_the_land, TAR_CHAR_SELF},//Meerclar
    { SPFUNC_DAMTYPE, "spell_summon", spell_summon, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_sunfire", spell_sunfire, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_teleport", spell_teleport, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_totemstaff", spell_totemstaff, TAR_IGNORE },
    { SPFUNC_DAMTYPE, "spell_thorny_feet", spell_thorny_feet, TAR_MOB_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_tough_skin", spell_tough_skin, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_treeform", spell_treeform, TAR_CHAR_SELF },
    { SPFUNC_NODAMTYPE, "spell_true_sight", spell_true_sight, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_unholy_aura", spell_unholy_aura, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_utterdark", spell_utterdark, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_vampiric_touch", spell_vampiric_touch, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_ventriloquate", spell_ventriloquate, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_wall_of_fire", spell_wall_of_fire, TAR_CHAR_DEFENSIVE },
    { SPFUNC_NODAMTYPE, "spell_wall_of_ice", spell_wall_of_ice, TAR_CHAR_DEFENSIVE },
    { SPFUNC_DAMTYPE, "spell_weaken", spell_weaken, TAR_MOB_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_wildstrike", spell_wildstrike, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_wizard_eye", spell_wizard_eye, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_wind_shield", spell_wind_shield, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_word_of_recall", spell_word_of_recall, TAR_CHAR_SELF},
    { SPFUNC_NODAMTYPE, "spell_sb_word_of_recall", spell_sb_word_of_recall, TAR_CHAR_SELF},//Meerclar
    { SPFUNC_DAMTYPE, "spell_wrath", spell_wrath, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_vicegrip", spell_vicegrip, TAR_CHAR_SELF },//Meerclar
    { SPFUNC_NODAMTYPE, "spell_summon_guardian", spell_summon_guardian, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_element_ring", spell_element_ring, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_summon_vyr", spell_summon_vyr, TAR_IGNORE},
    { SPFUNC_NODAMTYPE, "spell_summon_justice", spell_summon_justice, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_acid_breath", spell_acid_breath, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_fire_breath", spell_fire_breath, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_frost_breath", spell_frost_breath, TAR_CHAR_OFFENSIVE},
    { SPFUNC_DAMTYPE, "spell_gas_breath", spell_gas_breath, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_shadow_breath", spell_shadow_breath, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_steel_breath", spell_steel_breath, TAR_IGNORE},
    { SPFUNC_DAMTYPE, "spell_lightning_breath", spell_lightning_breath, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NODAMTYPE, "spell_logic", spell_logic, TAR_CHAR_SELF },
    { SPFUNC_NODAMTYPE, "spell_mnemonics", spell_mnemonics, TAR_CHAR_SELF },
    { SPFUNC_NODAMTYPE, "spell_lucidity", spell_lucidity, TAR_CHAR_SELF },
    { SPFUNC_NODAMTYPE, "spell_clarity", spell_clarity, TAR_CHAR_SELF },
    { SPFUNC_NODAMTYPE, "spell_persuasion", spell_persuasion, TAR_CHAR_SELF },
    { SPFUNC_NODAMTYPE, "spell_night_eyes", spell_night_eyes, TAR_CHAR_DEFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_general_purpose", spell_general_purpose, TAR_CHAR_OFFENSIVE},
    { SPFUNC_NOTEXT|SPFUNC_DAMTYPE, "spell_high_explosive", spell_high_explosive, TAR_CHAR_OFFENSIVE},
    { 0, "", NULL, TAR_IGNORE}
};
/**************************************************************************/
/**************************************************************************/


